<?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $timeName = \App\Models\TimeSetting::where('time', $data->time)->first();
    ?>
    <div class="col-xl-3 col-lg-4 col-md-6">
        <div class="package-card text-center bg_img"
            data-background="<?php echo e(asset($activeTemplateTrue . '/images/bg/bg-4.png')); ?>">
            <h4 class="package-card__title base--color mb-2"><?php echo e(__($data->name)); ?></h4>

            <ul class="package-card__features mt-4">
                <li><?php echo app('translator')->get('Return'); ?>
                    <?php echo e(showAmount($data->interest)); ?><?php echo e($data->interest_type == 1 ? '%' : ' ' . __($general->cur_text)); ?>

                </li>

                <li>
                    <?php echo app('translator')->get('Every'); ?> <?php echo e(__($timeName->name)); ?>

                </li>
                <li><?php echo app('translator')->get('For'); ?> <?php if($data->lifetime == 0): ?>
                        <?php echo e(__($data->repeat_time)); ?> <?php echo e(__($timeName->name)); ?>

                    <?php else: ?>
                        <?php echo app('translator')->get('Lifetime'); ?>
                    <?php endif; ?>
                </li>
                <li>
                    <?php if($data->lifetime == 0): ?>
                        <?php echo app('translator')->get('Total'); ?>
                        <?php echo e(__($data->interest * $data->repeat_time)); ?><?php echo e($data->interest_type == 1 ? '%' : ' ' . __($general->cur_text)); ?>

                        <?php if($data->capital_back == 1): ?>
                            +
                            <span class="badge badge--success"><?php echo app('translator')->get('Capital'); ?></span>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php echo app('translator')->get('Lifetime Earning'); ?>
                    <?php endif; ?>
                </li>
            </ul>
            <div class="package-card__range mt-5 base--color">
                <?php if($data->fixed_amount == 0): ?>
                    <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($data->minimum)); ?> -
                    <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($data->maximum)); ?>

                <?php else: ?>
                    <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($data->fixed_amount)); ?>

                <?php endif; ?>
            </div>
            <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#investModal"
                data-plan="<?php echo e($data); ?>" class="btn--base btn-md mt-4 investModal"><?php echo app('translator')->get('Invest Now'); ?></a>
        </div><!-- package-card end -->
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<div class="modal fade" id="investModal">
    <div class="modal-dialog modal-dialog-centered modal-content-bg">
        <div class="modal-content">
            <div class="modal-header">
                <?php if(auth()->check()): ?>
                <strong class="modal-title text-white" id="ModalLabel">
                    <?php echo app('translator')->get('Confirm to invest on'); ?> <span class="planName"></span>
                </strong>
                <?php else: ?>
                    <strong class="modal-title text-white" id="ModalLabel">
                        <?php echo app('translator')->get('At first sign in your account'); ?>
                    </strong>
                <?php endif; ?>
                <button type="button" class="close" data-bs-dismiss="modal">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('user.invest.submit')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="plan_id">
                <?php if(auth()->check()): ?>
                <div class="modal-body">
                    <div class="form-group">
                        <h6 class="text-center investAmountRange"></h6>
                        <p class="text-center mt-1 interestDetails"></p>
                        <p class="text-center interestValidity"></p>

                        <label><?php echo app('translator')->get('Select Wallet'); ?></label>
                        <select class="form-control form-select" name="wallet_type" required>
                            <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                            <?php if(auth()->user()->deposit_wallet > 0): ?>
                                <option value="deposit_wallet"><?php echo app('translator')->get('Deposit Wallet - ' . $general->cur_sym . showAmount(auth()->user()->deposit_wallet)); ?></option>
                            <?php endif; ?>
                            <?php if(auth()->user()->interest_wallet > 0): ?>
                                <option value="interest_wallet"><?php echo app('translator')->get('Interest Wallet -' . $general->cur_sym . showAmount(auth()->user()->interest_wallet)); ?></option>
                            <?php endif; ?>
                            <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($data->id); ?>" <?php if(old('wallet_type') == $data->method_code): echo 'selected'; endif; ?> data-gateway="<?php echo e($data); ?>"><?php echo e($data->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <code class="gateway-info rate-info d-none"><?php echo app('translator')->get('Rate'); ?>: 1 <?php echo e($general->cur_text); ?> = <span class="rate"></span> <span class="method_currency"></span></code>
                    </div>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Invest Amount'); ?></label>
                        <div class="input-group">
                            <input type="number" step="any" class="form-control" name="amount" required>
                            <div class="input-group-text bg--base"><?php echo e($general->cur_text); ?></div>
                        </div>
                        <code class="gateway-info d-none"><?php echo app('translator')->get('Charge'); ?>: <span class="charge"></span> <?php echo e($general->cur_text); ?>. <?php echo app('translator')->get('Total amount'); ?>: <span class="total"></span> <?php echo e($general->cur_text); ?></code>
                    </div>
                </div>
                <?php endif; ?>
                <div class="modal-footer">
                    <?php if(auth()->check()): ?>
                        <button type="button" class="btn btn-danger btn-md" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit" class="btn btn--base btn-md"><?php echo app('translator')->get('Yes'); ?></button>
                    <?php else: ?>
                        <a href="<?php echo e(route('user.login')); ?>" class="btn--base btn-md w-100 text-center"><?php echo app('translator')->get('At first sign in your account'); ?></a>
                    <?php endif; ?>
                </div>
            </form>
        </div>
    </div>
  </div>


<?php $__env->startPush('script'); ?>
<script>
    (function($) {
        "use strict"
        $('.investModal').click(function() {
            var symbol = '<?php echo e($general->cur_sym); ?>';
            var currency = '<?php echo e($general->cur_text); ?>';
            $('.gateway-info').addClass('d-none');
            var modal = $('#investModal');
            var plan = $(this).data('plan');

            modal.find('.planName').text(plan.name)
            modal.find('[name=plan_id]').val(plan.id);
            let fixedAmount = parseFloat(plan.fixed_amount).toFixed(2);
            let minimumAmount = parseFloat(plan.minimum).toFixed(2);
            let maximumAmount = parseFloat(plan.maximum).toFixed(2);
            let interestAmount = parseFloat(plan.interest);

            if (plan.fixed_amount > 0) {
                modal.find('.investAmountRange').text(`Invest: ${symbol}${fixedAmount}`);
                modal.find('[name=amount]').val(fixedAmount);
                modal.find('[name=amount]').attr('readonly', true);
            } else {
                modal.find('.investAmountRange').text(`Invest: ${symbol}${minimumAmount} - ${symbol}${maximumAmount}`);
                modal.find('[name=amount]').val('');
                modal.find('[name=amount]').removeAttr('readonly');
            }

            if (plan.interest_type == '1') {
                modal.find('.interestDetails').html(`<strong> Interest: ${interestAmount}% </strong>`);
            } else {
                modal.find('.interestDetails').html(`<strong> Interest: ${interestAmount} ${currency}  </strong>`);
            }
            if (plan.lifetime == '0') {
                modal.find('.interestValidity').html(`<strong>  Per ${plan.time} hours ,  ${plan.repeat_time} times</strong>`);
            } else {
                modal.find('.interestValidity').html(`<strong>  Per ${plan.time} hours,  life time </strong>`);
            }

        });

        $('[name=amount]').on('input', function() {
            $('[name=wallet_type]').trigger('change');
        })

        $('[name=wallet_type]').change(function() {
            var amount = $('[name=amount]').val();
            if ($(this).val() != 'deposit_wallet' && $(this).val() != 'interest_wallet' && amount) {
                var resource = $('select[name=wallet_type] option:selected').data('gateway');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);
                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                $('.charge').text(charge);
                $('.rate').text(parseFloat(resource.rate));
                $('.gateway-info').removeClass('d-none');
                if (resource.currency == '<?php echo e($general->cur_text); ?>') {
                    $('.rate-info').addClass('d-none');
                } else {
                    $('.rate-info').removeClass('d-none');
                }
                $('.method_currency').text(resource.currency);
                $('.total').text(parseFloat(charge) + parseFloat(amount));
            } else {
                $('.gateway-info').addClass('d-none');
            }
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php /**PATH /home/u601826248/domains/1xmoneyads.online/public_html/testhyip/core/resources/views/templates/bit_gold/partials/plan.blade.php ENDPATH**/ ?>